% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recursiveforecast.R
\name{recursiveforecast}
\alias{recursiveforecast}
\title{Recursively Forecasts a VAR}
\usage{
recursiveforecast(mod, h = 1, lambda = NULL)
}
\arguments{
\item{mod}{VAR model estimated using \code{sparseVAR}}

\item{h}{Desired forecast horizon. Default is h=1.}

\item{lambda}{Either \code{NULL} in which case a forecast will be made for all
lambdas for which the model was estimated, or a single value in which
case a forecast will only be made for the model using this lambda.
Choice is redundant if the model was estimated using a selection procedure.}
}
\value{
Returns an object of S3 class \code{bigtime.recursiveforecast} containing
\item{fcst}{Matrix or 3D array of forecasts}
\item{h}{Selected forecast horizon}
\item{lambda}{List of lambdas for which the forecasts were made}
\item{Y}{Data used for recursive forecasting}
}
\description{
Recursively forecasts a VAR estimated using sparseVAR.
lambda can either be NULL, in which case all lambdas that were used for
model estimation are used for forecasting, or a single value, in which case
only the model using this lambda will be used for forecasting.
}
\examples{
sim_data <- simVAR(periods=200, k=5, p=5, seed = 12345)
summary(sim_data)
mod <- sparseVAR(Y=scale(sim_data$Y), selection = "bic")
is.stable(mod)
fcst_recursive <- recursiveforecast(mod, h = 4)
plot(fcst_recursive, series = "Y1")
fcst_direct <- directforecast(mod)
fcst_direct
fcst_recursive$fcst
}
