% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database-stats.R
\name{bike_demographic_data}
\alias{bike_demographic_data}
\title{Static summary of which systems provide demographic data}
\usage{
bike_demographic_data()
}
\value{
A \code{data.frame} detailing the kinds of demographic data provided
by the different systems
}
\description{
Static summary of which systems provide demographic data
}
\examples{
bike_demographic_data ()
# Examples of filtering data by demographic parameters:
\dontrun{
data_dir <- tempdir ()
bike_write_test_data (data_dir = data_dir)
bikedb <- file.path (data_dir, 'testdb')
store_bikedata (data_dir = data_dir, bikedb = bikedb)
# create database indexes for quicker access:
index_bikedata_db (bikedb = bikedb)

sum (bike_tripmat (bikedb = bikedb, city = 'bo')) # 200 trips
sum (bike_tripmat (bikedb = bikedb, city = 'bo', birth_year = 1990)) # 9
sum (bike_tripmat (bikedb = bikedb, city = 'bo', gender = 'f')) # 22
sum (bike_tripmat (bikedb = bikedb, city = 'bo', gender = 2)) # 22
sum (bike_tripmat (bikedb = bikedb, city = 'bo', gender = 1)) # = m; 68
sum (bike_tripmat (bikedb = bikedb, city = 'bo', gender = 0)) # = n; 9
# Sum of gender-filtered trips is less than total because \code{gender = 0}
# extracts all registered users with unspecified genders, while without gender
# filtering extracts all trips for registered and non-registered users.

# The following generates an error because Washinton DC's DivvyBike system does
# not provide demographic data
sum (bike_tripmat (bikedb = bikedb, city = 'dc', birth_year = 1990))
bike_rm_test_data (data_dir = data_dir)
bike_rm_db (bikedb)
}
}
