% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_helpers.R
\name{bb_treemapchart}
\alias{bb_treemapchart}
\title{Helper for creating a treemap chart}
\usage{
bb_treemapchart(bb, data, mapping = NULL, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{data}{A \code{data.frame}, the first column will be used for x axis unless
specified otherwise in \code{mapping}. If not a \code{data.frame}, an object coercible to \code{data.frame}.}

\item{mapping}{Mapping of variables on the chart, see \code{\link{bbaes}}.}

\item{...}{Arguments passed to \code{\link{bb_treemap}}.}
}
\description{
Helper for creating a treemap chart
}
\examples{
library("billboarder")
data("mpg", package = "ggplot2")

billboarder() \%>\% 
  bb_treemapchart(mpg[, 1])

billboarder() \%>\% 
  bb_treemapchart(
    data = mpg, 
    mapping = aes(x = manufacturer),
    label = list(show = TRUE, threshold = 0.3)
  ) \%>\% 
  bb_data(
    labels = list(colors = "#FFF")
  )
}
