% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inf.Array.R
\name{Inf.Array}
\alias{Inf.Array}
\title{Informative array testing without master pooling}
\usage{
Inf.Array(p, Se, Sp, group.sz, obj.fn, weights, alpha)
}
\arguments{
\item{p}{the probability of disease, which can be an overall probability of disease,
from which a heterogeneous vector of individual probabilities will be generated, or
a vector of individual probabilities specified by the user}

\item{Se}{the sensitivity of the diagnostic test}

\item{Sp}{the specificity of the diagnostic test}

\item{group.sz}{a single group size (representing the row/column size)
for which to calculate the operating characteristics, or a range of group
(row/column) sizes over which to find the optimal testing configuration}

\item{obj.fn}{a list of objective functions which are minimized to find the
optimal testing configuration. Available options include "\kbd{ET}" (the expected
number of tests per individual), "\kbd{MAR}" (the expected number of tests divided
by the expected number of correct classifications, described in Malinovsky et al. (2016)),
\url{http://www.chrisbilder.com/grouptesting/HBTM/} for additional details.}

\item{weights}{a matrix of up to six sets of weights for the GR function. Each set of
weights is specified by a row of the matrix.}

\item{alpha}{a scale parameter for the beta distribution that specifies the degree of
heterogeneity for the generated probability vector}
}
\value{
A list containing:
\item{prob}{the overall probability of disease or vector of individual probabilities, as specified by the user}
\item{alpha}{the level of heterogeneity used to generate the vector of individual probabilities}
\item{Se}{the sensitivity of the diagnostic test}
\item{Sp}{the specificity of the diagnostic test}
\item{opt.ET, opt.MAR, opt.GR}{a list for each objective function specified by the user, containing:
\describe{
\item{OTC}{a list specifying the optimal testing configuration, which includes:
\describe{
\item{Array.dim}{the row/column size for the first stage of testing}
\item{Array.sz}{the overall array size (the square of the row/column size)}}}
\item{p.mat}{the sorted matrix of individual probabilities, arranged using the gradient method described by McMahan et al. (2012b)}
\item{ET}{the expected testing expenditure for the OTC}
\item{value}{the value of the objective function per individual}
\item{PSe}{the overall pooling sensitivity for the algorithm}
\item{PSp}{the overall pooling specificity for the algorithm}
\item{PPPV}{the overall pooling positive predictive value for the algorithm}
\item{PNPV}{the overall pooling negative predictive value for the algorithm}}}
}
\description{
Find the optimal testing configuration for
informative array testing without master pooling and calculate
the associated operating characteristics.
}
\details{
This function finds the optimal testing configuration and
computes the associated operating characteristics for informative
array testing without master pooling, implemented using the
gradient arrangement described in McMahan et al. (2012b). Array
testing with master pooling involves amalgamating specimens in rows
and columns for the first stage of testing. This function uses only
square arrays, which is the way array-based group testing is carried
out in most real-world applications. See Hitt et al. (2018)
at \url{http://www.chrisbilder.com/grouptesting/HBTM/}
McMahan et al. (2012b) for additional details.
}
\examples{
# Find the optimal testing configuration for informative array
#   testing without master pooling over a range of group
#   (row/column) sizes
\dontrun{Inf.Array(p=0.03, Se=0.99, Sp=0.99, group.sz=5:10, obj.fn=c("ET", "MAR"),
weights=NULL, alpha=2)}

# Find the optimal testing configuration for a specified group
#   (row/column) size for informative array testing without
#   master pooling
Inf.Array(p=rbeta(10,2,200), Se=0.95, Sp=0.95, group.sz=10,
obj.fn=c("ET", "MAR", "GR"),
weights=matrix(data=c(1,1,10,10), nrow=2, ncol=2, byrow=TRUE),
alpha=NA)

}
\references{
\emph{Graff, L.E. & Roeloffs, R. (1972)}. Group testing in the presence of
test error; an extension of the Dorfman procedure. \emph{Technometrics, 14, 113-122}.

\emph{Malinovsky, Y.; Albert, P.S. & Roy, A. (2016)}. Reader reaction: A note on
the evaluation of group testing algorithms in the presence of misclassification.
\emph{Biometrics, 72, 299-302}.

\emph{McMahan, C.S.; Tebbs, J.M. & Bilder, C.R. (2012b)}. Two-dimensional informative
array testing. \emph{Biometrics, 68, 793-804}.
}
\seealso{
\code{\link{NI.Array}} for non-informative array testing
without master pooling

\code{\link{NI.A2M}} for non-informative array testing
with master pooling

\code{\link{OTC}} for finding the optimal testing configuration for
a number of standard group testing algorithms

\url{http://chrisbilder.com/grouptesting/HBTM}

Other Optimal Testing Configuration functions: \code{\link{Inf.D3}},
  \code{\link{Inf.Dorf}}, \code{\link{NI.A2M}},
  \code{\link{NI.Array}}, \code{\link{NI.D3}},
  \code{\link{NI.Dorf}}, \code{\link{OTC}}
}
\author{
Brianna Hitt
}
