% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtReg.R
\name{residuals.gtReg}
\alias{residuals.gtReg}
\title{Extract model residuals from a fitted group testing model}
\usage{
\method{residuals}{gtReg}(object, type = c("deviance", "pearson", "response"), ...)
}
\arguments{
\item{object}{An object of class "gtReg", created by \code{\link{gtReg}},
from which the model residuals are to be extracted.}

\item{type}{The type of residuals which should be returned. Options include
"\kbd{deviance}" (default), "\kbd{pearson}", and "\kbd{response}".}

\item{...}{currently not used.}
}
\value{
Residuals of group responses extracted from the object \kbd{object}.
}
\description{
Extract model residuals from objects of class "gtReg" returned
by \code{\link{gtReg}}.
}
\examples{
data(hivsurv)
fit1 <- gtReg(formula = groupres ~ AGE * EDUC.,
              data = hivsurv, groupn = gnum,
              linkf = "probit")
residuals(object = fit1, type = "pearson")
residuals(object = fit1, type = "deviance")
}
\author{
This function was originally written by Boan Zhang as the
\kbd{residuals.gt} function for the \code{binGroup} package.
}
