% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLong.R
\name{MMLongit}
\alias{MMLongit}
\title{Function used to fit marginalized models}
\usage{
MMLongit(
  params,
  id,
  X,
  Y,
  Xgam,
  Xsig,
  Q,
  weight = rep(1, length(Y)),
  offset = rep(0, length(Y)),
  stepmax = 1,
  steptol = 1e-06,
  hess.eps = 1e-07,
  AdaptiveQuad = FALSE,
  verbose = FALSE,
  iterlim
)
}
\arguments{
\item{params}{a vector of initial values.}

\item{id}{a vector of cluster identifiers.}

\item{X}{a design matrix, including intercept, for the mean formula.}

\item{Y}{a binary vector}

\item{Xgam}{a design matrix for the transition formula.}

\item{Xsig}{a design matrix for the latent variable formula.}

\item{Q}{a scalar denoting the number of quadrature points.}

\item{weight}{a vector of sampling weights.}

\item{offset}{an optional offset term.}

\item{stepmax}{a scalar}

\item{steptol}{a scalar}

\item{hess.eps}{a scalar}

\item{AdaptiveQuad}{an indicator if adaptive quadrature is to be used. NOT CURRENTLY IMPLEMENTED.}

\item{verbose}{an indicator if model output should be printed to the screen during maximization (or minimization of negative log-likelihood).
See print.level in \code{nlm}.}

\item{iterlim}{a scalar to denote the maximum iteration limit used by nlm. Default value is 100}
}
\value{
This function returns marginal parameters (beta) and dependence parameters (alpha) along with the associated covariance matrices.
}
\description{
Main function used to fit marginalized models. See mm() for a more user-friendly function and examples}

