% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.dist.binned.boot.cpp.R
\name{bw.dist.binned.boot}
\alias{bw.dist.binned.boot}
\title{Bootstrap bandwidth selector for kernel distribution estimation and binned data.}
\usage{
bw.dist.binned.boot(n, y, w, ni, g, pilot.type = 2, nit = 10,
  confband = FALSE, B = 1000, alpha = 0.05, print = TRUE,
  plot = TRUE, parallel = FALSE, pars = new.env())
}
\arguments{
\item{n}{Positive integer. Size of the complete sample.}

\item{y}{Vector. Observed values. They define the extremes of the sequence of intervals in which data is binned.}

\item{w}{Vector. Proportion of observations within each interval.}

\item{ni}{Vector. Number of observations within each interval.}

\item{g}{Positive real number. Pilot bandwidth. If missing, plug-in N bandwidth for the distribution is considered.}

\item{pilot.type}{1 or 2. If \code{g} is missing, pilot bandwidth for the bootstrap bandwidth selector is automatically selected using methods 1 or 2. Defaults to 1. See details for more information.}

\item{nit}{Positive integer. Number of iterations in the dichotomy algorithm for the estimation of the bootstrap bandwidth.}

\item{confband}{Logical. If TRUE, bootstrap confidence bands are constructed for the estimator. Defaults to FALSE.}

\item{B}{Positive integer. Number of bootstrap resamples used for the construction of the confidence bands. Defaults to 1000.}

\item{alpha}{Real number between 0 and 1. Significance level for the confidence bands. Defaults to 0.05}

\item{print}{Logical. If TRUE, script current status is printed. Defaults to TRUE.}

\item{plot}{Logical. If TRUE, results are plotted. Defaults to FALSE.}

\item{parallel}{Logical. If TRUE, confidence bands are estimated using parallel computing with sockets.}

\item{pars}{Environment. Needed for the well functioning of the script. DO NOT modify this argument.}
}
\value{
A list with components:
\item{h}{Bootstrap bandwidth for the distribution function.}
\item{Fh}{Function. Kernel distribution estimator with bandwidth \code{h}.}
\item{confband (optional)}{Matrix. Its columns contain the bootstrap confidence bands for the estimator.}
}
\description{
Bootstrap bandwidth selector for kernel distribution estimation and binned data.
}
\details{
If \code{pilot.type} = 1, plug-in bandwidth for the distribution is considered as pilot bandwidth for the bootstrap selector.

If \code{pilot.type} = 2, the pilot bandwidth is such that the kernel distribution estimator with bandwidth \code{g} approximates the empirical distribution of the grouped sample minimizing the residual sum of squares. Also, a penalty is imposed on the global slope of the kernel density estimator with bandwidth \code{g}. The penalty parameter is selected as to best approximate the global slope of the true density.
}
\examples{
set.seed(1)
n <- 200 #complete sample size
k <- 30 #number of intervals
x <- rnorm(n,6,1) #complete sample
y <- seq(min(x)-0.2,max(x)+0.2,len=k+1) #intervals
w <- c(sapply(2:k,function(i)sum( x<y[i]&x>=y[i-1] )), sum(x<=y[k+1]&x>=y[k]) )/n #proportions
bw.dist.binned.boot(n,y,w,plot=FALSE)

}
\references{
\insertRef{TesisMiguel2015}{binnednp}
}
