% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.vpts.R
\name{plot.vpts}
\alias{plot.vpts}
\title{Plot a time series of vertical profiles (\code{vpts})}
\usage{
\method{plot}{vpts}(
  x,
  xlab = "time",
  ylab = "height [m]",
  quantity = "dens",
  log = NA,
  barbs = TRUE,
  barbs_height = 10,
  barbs_time = 20,
  barbs_dens_min = 5,
  zlim,
  legend_ticks,
  legend.ticks,
  main,
  barbs.h = 10,
  barbs.t = 20,
  barbs.dens = 5,
  na_color = "#C8C8C8",
  nan_color = "white",
  n_color = 1000,
  palette = NA,
  ...
)
}
\arguments{
\item{x}{A vp class object inheriting from class \code{vpts}.}

\item{xlab}{A title for the x-axis.}

\item{ylab}{A title for the y-axis.}

\item{quantity}{Character string with the quantity to plot,
one of '\code{dens}','\code{eta}','\code{dbz}','\code{DBZH}' for density,
reflectivity, reflectivity factor and total reflectivity factor,
respectively.}

\item{log}{Logical, whether to display \code{quantity} data on a
logarithmic scale.}

\item{barbs}{Logical, whether to overlay speed barbs.}

\item{barbs_height}{Integer, number of barbs to plot in altitudinal dimension.}

\item{barbs_time}{Integer, number of barbs to plot in temporal dimension.}

\item{barbs_dens_min}{Numeric, lower threshold in aerial density of individuals
for plotting speed barbs in individuals/km^3.}

\item{zlim}{Optional numerical atomic vector of length 2, specifying the
range of \code{quantity} values to plot.}

\item{legend_ticks}{Numeric atomic vector specifying the ticks on the
color bar.}

\item{legend.ticks}{Deprecated argument, use legend_ticks instead.}

\item{main}{A title for the plot.}

\item{barbs.h}{Deprecated argument, use barbs_height instead.}

\item{barbs.t}{Deprecated argument, use barbs_time instead.}

\item{barbs.dens}{Deprecated argument, use barbs_dens_min instead.}

\item{na_color}{Color to use for NA values, see class \code{\link[=summary.vpts]{vpts}} conventions.}

\item{nan_color}{Color to use for NaN values, see class \code{\link[=summary.vpts]{vpts}} conventions.}

\item{n_color}{The number of colors (>=1) to be in the palette.}

\item{palette}{(Optional) character vector of hexadecimal color values defining
the plot color scale, e.g. output from \link[viridisLite]{viridis}}

\item{...}{Additional arguments to be passed to the low level
\link[graphics]{image} plotting function.}
}
\description{
Plot a time series of vertical profiles  of class \code{vpts}.
}
\details{
Aerial abundances can be visualized in four related quantities, as specified
by argument \code{quantity}:
\describe{
\item{"\code{dens}"}{the aerial density of individuals. This quantity is
dependent on the assumed radar cross section (RCS) in the
\code{x$attributes$how$rcs_bird} attribute}
\item{"\code{eta}"}{reflectivity. This quantity is independent of the
value of the \code{rcs_bird} attribute}
\item{"\code{dbz}"}{reflectivity factor. This quantity is independent
of the value of the \code{rcs_bird} attribute, and corresponds to the
dBZ scale commonly used in weather radar meteorology. Bioscatter by birds
tends to occur at much higher reflectivity factors at S-band
than at C-band}
\item{"\code{DBZH}"}{total reflectivity factor. This quantity equals the
reflectivity factor of all scatterers (biological and meteorological
scattering combined)}
}

Aerial velocities can be visualized in three related quantities, as specified
by argument \code{quantity}:
\describe{
\item{"\code{ff}"}{ground speed. The aerial velocity relative to the
ground surface in m/s.}
\item{"\code{u}"}{eastward ground speed component in m/s.}
\item{"\code{v}"}{northward ground speed component in m/s.}
}
\subsection{barbs}{

In the speed barbs, each half flag represents 2.5 m/s, each full flag 5 m/s,
each pennant (triangle) 25 m/s
}

\subsection{legend_ticks / zlim}{

Default legend ticks and plotting range are specified based on \code{quantity},
radar wavelength (S- vs C-band), and value of \code{log}
}

\subsection{log}{

Quantities \code{u} and \code{v} cannot be plotted on a logarithmic scale, because
these quantities assume negative values.  For quantities \code{DBZH} and \code{dbz}
\code{log=TRUE} is ignored, because these quantities are already logarithmic.
}
}
\examples{
# locate example file:
ts <- example_vpts
# plot density of individuals for the first 500 time steps, in the altitude
# layer 0-3000 m.
plot(ts[1:500], ylim = c(0, 3000))
# plot total reflectivity factor (rain, birds, insects together):
plot(ts[1:500], ylim = c(0, 3000), quantity = "DBZH")
# regularize the time grid, which includes empty (NA) profiles at
# time steps without data:
ts_regular <- regularize_vpts(ts)
plot(ts_regular)
# change the color of missing NA data to red
plot(ts_regular, na_color="red")
# change the color palette:
plot(ts_regular[1:1000], ylim = c(0, 3000), palette=viridis::viridis(1000))
# change and inverse the color palette:
plot(ts_regular[1:1000], ylim = c(0, 3000), palette=rev(viridis::viridis(1000, option="A")))
# plot the speed profile:
plot(ts_regular[1:1000], quantity="ff")
# plot the northward speed component:
plot(ts_regular[1:1000], quantity="v")
# plot speed profile with more legend ticks,
plot(ts_regular[1:1000], quantity="ff", legend_ticks=seq(0,20,2), zlim=c(0,20))
}
