% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BatBioacoustics.R
\name{threshold_detection}
\alias{threshold_detection}
\title{Amplitude threshold detector above Signal to Noise Ratio (SNR)}
\usage{
threshold_detection(wave, threshold = 14, channel = "left",
  time_exp = 1, min_dur = 1.5, max_dur = 80, min_TBE = 20,
  max_TBE = 1000, EDG = 0.996, LPF, HPF = 16000, FFT_size = 256,
  FFT_overlap = 0.875, start_thr = 40, end_thr = 20, SNR_thr = 10,
  angle_thr = 40, duration_thr = 80, NWS = 100, KPE = 1e-05,
  KME = 1e-05, settings = FALSE, acoustic_feat = TRUE,
  metadata = FALSE, spectro_dir = NULL, time_scale = 0.1,
  ticks = TRUE)
}
\arguments{
\item{wave}{either a path to a file, or a \link[tuneR]{Wave} object.

Audio files will be automatically decoded internally using the function \link{read_audio}.}

\item{threshold}{integer. Sensitivity of the audio event detection function (peak-picking algorithm) in dB.
A threshold value of 14 dB above SNR is recommended. Higher values increase the risk of leaving audio events undetected (false negative).
In a noisy recording (low SNR) this sensitivity threshold may be set at 12 dB,
but a value below 10 dB is not recommended. Default setting is 14 dB above SNR.}

\item{channel}{character. Channel to keep for analysis in a stereo recording: 'left' or 'right'.
Do not need to be specified for mono recordings, recordings with more than two channels are not
yet supported. Default setting is 'left'.}

\item{time_exp}{integer. Time expansion factor of the recording.
Set to 1 for real-time recording or above for time expanded recording. Default setting is 1.}

\item{min_dur}{numeric. Minimum duration threshold in milliseconds (ms).
Extracted audio events shorter than this threshold are ignored. Default setting is 1.5 ms.}

\item{max_dur}{numeric. Maximum duration threshold in milliseconds (ms).
Extracted audio events longer than this threshold are ignored. The default setting is 80 ms.}

\item{min_TBE}{numeric. Minimum time window between two audio events in milliseconds (ms). If the time interval between two
successive audio events is shorter than this window, they are ignored. The default setting is 20 ms.}

\item{max_TBE}{numeric. Maximum time window between two audio events in milliseconds (ms). If the time interval between two
successive audio events is longer than this window, they are ignored. The default setting is 1000 ms.}

\item{EDG}{numeric. Exponential Decay Gain from 0 to 1. Sets the degree of temporal masking at the end of each audio event.
This filter avoids extracting noise or echoes at the end of the audio event. The default setting is 0.996.}

\item{LPF}{integer. Low-Pass Filter (Hz). Frequencies above the cutoff are greatly attenuated.
Default is set internally at the Nyquist frequency of the recording.}

\item{HPF}{integer. High-Pass Filter (Hz). Frequencies below the cutoff are greatly attenuated.
Default setting is 16000 Hz. A default of 1000 Hz is recommended for most bird vocalizations.}

\item{FFT_size}{integer. Size of the Fast Fourrier Transform (FFT) window. Default setting is 256.}

\item{FFT_overlap}{numeric. Percentage of overlap between two FFT windows (from 0 to 1). Default setting is 0.875.}

\item{start_thr}{integer. Right to left amplitude threshold (dB) for audio event extraction, from the audio event centroid.
The last FFT where the amplitude level is equal or above this threshold is considered the start of the audio event.
Default setting is 40 dB. 20 dB is recommended for extracting bird vocalizations.}

\item{end_thr}{integer. Left to right amplitude threshold (dB) for audio event extraction, from the audio event centroid.
The last FFT where the amplitude level is equal or above this threshold is considered the end of the audio event.
Default setting is 20 dB. 30 dB is recommended for extracting bird vocalizations.}

\item{SNR_thr}{integer. SNR threshold (dB) at which the extraction of the audio event stops.
Default setting is 10 dB. 8 dB is recommended for bird vocalizations.}

\item{angle_thr}{integer. Angle threshold (°) at which the audio event extraction stops.
Default setting is 40°. 125° is recommended for extracting bird vocalizations.}

\item{duration_thr}{integer. Maximum duration threshold in milliseconds (ms) after which the monitoring of the background noise is resumed.
Default setting is 80 ms for bat echolocation calls. A higher threshold value is recommended for extracting bird vocalizations.}

\item{NWS}{integer. Length of the time window used for background noise estimation in the recording (ms).
A longer window size is less sensitive to local variations in the background noise.
Default setting is 100 ms.}

\item{KPE}{numeric. Set the Process Error parameter of the Kalman filter.
Default setting is 1e-05.}

\item{KME}{numeric. Set the Measurement Error parameter of the Kalman filter.
Default setting is 1e-05.}

\item{settings}{logical. \code{TRUE} or \code{FALSE}. Save on a list the parameters set with the threshold_detection function.
Default setting is \code{FALSE}.}

\item{acoustic_feat}{logical. \code{TRUE} or \code{FALSE}. Extracts the acoustic and signal quality parameters from each audio event in a data frame.
The sequences of smoothed amplitude (dB) and frequency (Hz) bins of each audio event, temporal values (in ms)
 of the beginning and the end of each audio event are also extracted in separate lists. Default setting is \code{TRUE}.}

\item{metadata}{logical. \code{TRUE} or \code{FALSE}. Extracts on a list the metadata embedded with the Wave file
GUANO metadata extraction is not -yet- implemented. Default setting is \code{FALSE}.}

\item{spectro_dir}{character (path) or \code{NULL}. Generate an HTML page with the spectrograms numbered by order
of detection in the recording. Spectrograms are generated as individual .PNG files and stored in the
'spectro_dir/spectrograms' subdirectory. The R working directory is used if \code{spectro_dir} is \code{NULL}.
\code{spectro_dir} is set to \code{NULL} by default.}

\item{time_scale}{numeric. Time resolution of the spectrogram in milliseconds (ms) per pixel (px). Default setting is 0.1 ms for bat echolocation calls.
A default of 2 ms/px is recommended for most bird vocalizations.}

\item{ticks}{either logical or numeric. If \code{TRUE} tickmarks are drawn on the (frequency)
y-axis and their positions are computed automatically. If numeric, sets the
lower and upper limits of the tickmarks and their interval (in Hz). Default setting is \code{TRUE}.}
}
\value{
an object of class 'bioacoustics_output'.
}
\description{
This function is a modified version of the Bat Bioacoustics freeware developed by Christopher Scott (2012).
It combines several detection, filtering and audio feature extraction algorithms.
}
\examples{
data(myotis)
Output <- threshold_detection(myotis, time_exp = 10, HPF = 16000, LPF = 200000)
Output$data

}
