% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbRecord-class.R,
%   R/gbRecordList-class.R
\docType{methods}
\name{getFeatures}
\alias{getFeatures}
\alias{ft}
\alias{getFeatures,gbRecord-method}
\alias{ft,gbRecord-method}
\alias{getFeatures,gbRecordList-method}
\alias{ft,gbRecordList-method}
\title{Get the feature table from a GenBank record.}
\usage{
getFeatures(x, ...)

ft(x, ...)

\S4method{getFeatures}{gbRecord}(x)

\S4method{ft}{gbRecord}(x)

\S4method{getFeatures}{gbRecordList}(x)

\S4method{ft}{gbRecordList}(x)
}
\arguments{
\item{x}{A \code{\linkS4class{gbRecord}} instance.}

\item{...}{Additional arguments passed to methods.}
}
\value{
The \code{\linkS4class{gbFeatureTable}} of a Genbank record.
}
\description{
Get the feature table from a GenBank record.
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
getFeatures(x)
ft(x)
}
