% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_counts.R
\name{distribution_to_logcount}
\alias{distribution_to_logcount}
\title{Distribution of times to reach a certain microbial count}
\usage{
distribution_to_logcount(model, log_count)
}
\arguments{
\item{model}{An instance of \code{StochasticGrowth} or \code{MCMCgrowth}.}

\item{log_count}{The target microbial count.}
}
\value{
An instance of \code{\link{TimeDistribution}}.
}
\description{
Returns the probability distribution of the storage time required for
the microbial count to reach \code{log_count} according to the predictions of
a stochastic \code{model}.
Calculations are done using linear interpolation of the individual
 model predictions.
}
\examples{
\donttest{
## We need an instance of StochasticGrowth

my_model <- "modGompertz"
my_times <- seq(0, 30, length = 100)
n_sims <- 3000

library(tibble)

pars <- tribble(
    ~par, ~mean, ~sd, ~scale,
    "logN0", 0, .2, "original",
    "mu", 2, .3, "sqrt",
    "lambda", 4, .4, "sqrt",
    "C", 6, .5, "original"
)

stoc_growth <- predict_stochastic_growth(my_model, my_times, n_sims, pars)

## We can now call the function

time_distrib <- distribution_to_logcount(stoc_growth, 4)

## And plot the results

plot(time_distrib)
}

}
