% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_isothermal_growth.R
\name{iso_repGompertz}
\alias{iso_repGompertz}
\alias{modGompertz}
\alias{gompertz}
\title{Reparameterized Gompertz model}
\usage{
iso_repGompertz(times, logN0, C, mu, lambda)
}
\arguments{
\item{times}{Numeric vector of storage times}

\item{logN0}{Initial log microbial count}

\item{C}{Difference between \code{logN0} and the maximum log-count.}

\item{mu}{Maximum specific growth rate (in ln CFU/[t])}

\item{lambda}{Lag phase duration}
}
\value{
Numeric vector with the predicted microbial count.
}
\description{
Reparameterized Gompertz growth model defined by Zwietering et al. (1990).
}
