% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GrowthUncertainty_class.R
\name{GrowthUncertainty}
\alias{GrowthUncertainty}
\alias{print.GrowthUncertainty}
\alias{plot.GrowthUncertainty}
\title{GrowthUncertainty class}
\usage{
\method{print}{GrowthUncertainty}(x, ...)

\method{plot}{GrowthUncertainty}(
  x,
  y = NULL,
  ...,
  line_col = "black",
  line_size = 0.5,
  line_type = "solid",
  ribbon80_fill = "grey",
  ribbon90_fill = "grey",
  alpha80 = 0.5,
  alpha90 = 0.4
)
}
\arguments{
\item{x}{The object of class \code{GrowthUncertainty} to plot.}

\item{...}{ignored.}

\item{y}{ignored}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link[=geom_line]{geom_line()}}}

\item{ribbon80_fill}{fill colour for the space between the 10th and 90th quantile, see: \code{\link[=geom_ribbon]{geom_ribbon()}}}

\item{ribbon90_fill}{fill colour for the space between the 5th and 95th quantile, see: \code{\link[=geom_ribbon]{geom_ribbon()}}}

\item{alpha80}{transparency of the ribbon aesthetic for the space between the 10th and 90th quantile. Takes a value between 0 (fully transparant) and 1 (fully opaque)}

\item{alpha90}{transparency of the ribbon aesthetic for the space between the 5th and 95th quantile. Takes a value between 0 (fully transparant) and 1 (fully opaque).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The \code{GrowthUncertainty} class contains the results of a growth prediction
under isothermal conditions considering parameter uncertainty. Its constructor
is \code{\link[=predict_growth_uncertainty]{predict_growth_uncertainty()}}.

It is a subclass of list with the items:
\itemize{
\item sample: parameter sample used for the calculations.
\item simulations: growth curves predicted for each parameter.
\item quantiles: limits of the credible intervals (5\%, 10\%, 50\%, 90\%, 95\%) for
each time point.
\item model: Model used for the calculations.
\item mus: Mean parameter values used for the simulations.
\item sigma: Variance-covariance matrix used for the simulations.
}
}
\section{Functions}{
\itemize{
\item \code{print.GrowthUncertainty}: print of the model

\item \code{plot.GrowthUncertainty}: Growth prediction (prediction band) considering
parameter uncertainty.
}}

