% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_guesses.R
\name{make_guess_secondary}
\alias{make_guess_secondary}
\title{Initial guesses for the parameters of a secondary model}
\usage{
make_guess_secondary(fit_data, sec_model_names)
}
\arguments{
\item{fit_data}{Tibble with the data used for the fit. It must have
one column with the observed growth rate (named \code{mu} by default; can be
changed using the "formula" argument) and as many columns
as needed with the environmental factors.}

\item{sec_model_names}{Named character vector defining the secondary model
for each environmental factor.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Uses some heuristic rules to generate an initial guess of the model parameters
of secondary growth models that can be used for model fitting with
\code{\link[=fit_secondary_growth]{fit_secondary_growth()}}.
}
\examples{

## We can use the example dataset included in the package

data("example_cardinal")

## We assign model equations to factors as usual

sec_model_names <- c(temperature = "Zwietering", pH = "fullRatkowsky")

## We can then calculate the initial guesses

make_guess_secondary(example_cardinal, sec_model_names)

## We can pass these parameters directly to fit_secondary_growth

fit_secondary_growth(example_cardinal, 
                     make_guess_secondary(example_cardinal, sec_model_names), 
                     c(), 
                     sec_model_names)

}
