% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-urls.r
\name{urls}
\alias{urls}
\alias{url_go}
\alias{url_kegg}
\alias{url_pubmed}
\alias{url_entrez}
\alias{url_cran}
\alias{url_bioc}
\title{Construct urls to online resources}
\usage{
url_go(id)

url_kegg(id)

url_pubmed(id)

url_entrez(id)

url_cran(id)

url_bioc(id)
}
\arguments{
\item{id}{valid identifier for the relevant online database}
}
\description{
These resource-specific functions return a bare url (i.e., not a hyperlink)
to the relevant online database/resource based on the provided identifier.
}
\section{Functions}{
\itemize{
\item \code{url_go}: for Gene Ontology Consortium

\item \code{url_kegg}: for KEGG Pathway Database

\item \code{url_pubmed}: for PubMed based on PMID (PubMed identifier)

\item \code{url_entrez}: for NCBI's database for gene-specific information based
on Entrez ID

\item \code{url_cran}: for R packages available from CRAN

\item \code{url_bioc}: for R packages available from Bioconductor
}}

\examples{
# gene ontology url
url_go("GO:0005539")

# KEGG pathway url
url_kegg("hsa04915")

# PubMed article url
url_pubmed("23193287")
}
