% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{CA}
\alias{CA}
\title{Correspondence Analysis (CA) method}
\usage{
CA(bp, dim.biplot = c(2,1,3), e.vects = 1:ncol(bp$X), variant = "Princ", 
lambda.scal = FALSE)
}
\arguments{
\item{bp}{object of class \code{biplot} obtained from preceding function \code{biplot(center = FALSE)}. In order to maintain the frequency table, the input should not be centered or scaled. For \code{CA}, \code{bp} should be a contingency table.}

\item{dim.biplot}{dimension of the biplot. Only values 1, 2 and 3 are accepted, with default \code{2}.}

\item{e.vects}{which eigenvectors (canonical variates) to extract, with default \code{1:dim.biplot}.}

\item{variant}{which correspondence analysis variant, with default "Princ", presents a biplot with rows in principal coordinates
and columns in standard coordinates. \code{variant = "Stand"}, presents a biplot with rows in standard coordinates and columns in
principal coordinates. \code{variant = "symmetric"}, presents a symmetric biplot with row and column standard coordinates scaled
equally by the singular values.}

\item{lambda.scal}{logical value to request lambda-scaling, default is \code{FALSE}.}
}
\value{
A list with the following components is available:
\item{Z}{Combined data frame of the row and column coordinates.}
\item{r}{Numer of levels in the row factor.}
\item{c}{Numer of levels in the column factor.}
\item{rowcoor}{Row coordinates based on the selected \code{variant}.}
\item{colcoor}{Column coordinates based on the selected \code{variant}.}
\item{P}{Correspondence Matrix}
\item{Smat}{Standardised Pearson residuals.}
\item{SVD}{Singular value decomposition solution: \code{d, u, v}.}
\item{qual}{Quality of the approximation.}
\item{lambda.val}{The computed lambda value if lambda-scaling is requested.}
}
\description{
This function produces a list of elements to be used for CA biplot construction by approximation of the Pearson residuals.
}
\examples{
# Creating a CA biplot with rows in principal coordinates:
biplot(HairEyeColor[,,2], center = FALSE) |> CA() |> plot()
# Creating a CA biplot with rows in standard coordinates:
biplot(HairEyeColor[,,2], center = FALSE) |> CA(variant = "Stand") |> 
samples(col=c("magenta","purple"), pch=c(15,17), label.col="black") |> plot()
# Creating a CA biplot with rows and columns scaled equally:
biplot(HairEyeColor[,,2], center = FALSE) |> CA(variant = "Symmetric") |> 
samples(col=c("magenta","purple"), pch=c(15,17), label.col="black") |> plot()
}
