% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_bitmap.R
\name{bm_bitmap}
\alias{bm_bitmap}
\title{Bitmap object}
\usage{
bm_bitmap(x)
}
\arguments{
\item{x}{Object to be converted to \code{bm_bitmap()}.
If not already an integer matrix it will be cast to one
by \code{\link[=as_bm_bitmap]{as_bm_bitmap()}}.}
}
\value{
An integer matrix with a \dQuote{bm_bitmap} subclass.
}
\description{
\code{bm_bitmap()} creates an S3 object representing bitmap.
}
\details{
Bitmaps are represented as integer matrices with special class methods.
The bottom left pixel is represented by the first row and first column.
The bottom right pixel is represented by the first row and last column.
The top left pixel is represented by the last row and first column.
The top right pixel is represented by the last row and last column.
Color bitmaps are supported (the integer can be any non-negative integer)
but we are unlikely to ever support exporting color bitmap fonts.
Color bitmaps can be cast to black-and-white bitmaps via \code{\link[=bm_clamp]{bm_clamp()}}.
}
\section{Supported S3 methods}{

\itemize{
\item \code{\link{[.bm_bitmap}} and \code{\link{[<-.bm_bitmap}}
\item \code{\link[=as.matrix.bm_bitmap]{as.matrix.bm_bitmap()}}
\item \code{\link[=as.raster.bm_bitmap]{as.raster.bm_bitmap()}} and \code{\link[=plot.bm_bitmap]{plot.bm_bitmap()}}
\item \code{\link[=cbind.bm_bitmap]{cbind.bm_bitmap()}} and \code{\link[=rbind.bm_bitmap]{rbind.bm_bitmap()}}
\item \code{\link[=format.bm_bitmap]{format.bm_bitmap()}} and \code{\link[=print.bm_bitmap]{print.bm_bitmap()}}
\item \code{\link[=Ops.bm_bitmap]{Ops.bm_bitmap()}} for all the S3 \dQuote{Ops} Group generic functions
\item \code{\link[=which.bm_bitmap]{which.bm_bitmap()}} (with \code{which()} re-defined as a generic)
}
}

\examples{
 space <- bm_bitmap(matrix(0, nrow = 16, ncol = 16))
 print(space, px = ".")
}
\seealso{
\code{\link[=as_bm_bitmap]{as_bm_bitmap()}}, \code{\link[=is_bm_bitmap]{is_bm_bitmap()}}
}
