% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdate.R
\name{getdate}
\alias{getdate}
\title{Obtaining dates using other dates (or month or year) as reference}
\usage{
getdate(expr, ref, cal = bizdays.options$get("default.calendar"))
}
\arguments{
\item{expr}{a character string specifying the date to be returned (see Details)}

\item{ref}{a \code{ref} object (see Details)}

\item{cal}{the calendar's name

\code{expr} represents the day has to be returned, here it follows a few examples:
\itemize{
  \item \code{"second day"}
  \item \code{"10th bizday"}
  \item \code{"3rd wed"}
  \item \code{"last bizday"}
  \item \code{"first fri"}
}

\code{expr} is a character string with two terms: \code{"<position> <day>"}
\itemize{
  \item positions: \code{first} or \code{1st},
  \code{second} or \code{2nd},
  \code{third} or \code{3rd}, \code{last} and \code{XXth} (examples
  \code{6th} or \code{11th})
  \item days: \code{day}, \code{bizday}, or weekdays (\code{sun}, \code{mon},
  \code{tue}, \code{wed}, \code{thu}, \code{fri}, \code{sat})
}

\code{getdate} returns dates according to a reference that can be a month or
an year. This reference is build with the \code{\link{ref}} object.
The \code{ref} object specifies a month or an year based on a date or the month
and year can be directly specified.}
}
\description{
Imagine you have one date and want the first or last day of this date's month.
For example, you have the date 2018-02-01 and want the last day of its month.
You have to check whether or not its year is a leap year, and this sounds a
tough task.
\code{getdate} helps with returning specific dates according to a reference
than can be another date, a month or an year.
}
\examples{
getdate("first day", ref("2018-01-01", ym = "month"), "actual")
getdate("10th wed", ref(2018), "actual")
getdate("last bizday", ref(2010:2018), "Brazil/ANBIMA")
dts <- seq(as.Date("2018-01-01"), as.Date("2018-12-01"), "month")
getdate("first bizday", ref(dts, ym = "month"), "Brazil/ANBIMA")
}
\seealso{
\code{\link{ref}}
}
