% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose_email.R
\name{compose_email}
\alias{compose_email}
\title{Create the email message}
\usage{
compose_email(body = NULL, footer = NULL, .preheader_text = NULL,
  .title = NULL, ...)
}
\arguments{
\item{body}{the main body of text for
the email message. Markdown can be used here
(along with string interpolation via curly
braces and named arguments) to construct the
main text.}

\item{footer}{the footer text for the email
message. As with the \code{body}, Markdown
and string interpolation can be used here.}

\item{.preheader_text}{text that appears
before the subject in some email clients.
This must be plaintext.}

\item{.title}{the title of the email message.
This is not the subject but the HTML title
text which may appear in limited
circumstances.}

\item{...}{expression strings for string
interpolation for the \code{body},
\code{footer}, and \code{preheader_text}
string data.}
}
\value{
an \code{email_message} object,
which can be used for previewing with
the \code{preview_email()} function or
for sending out actual emails with the
\code{send_email_out()} function.
}
\description{
Create an email message. String
interpolation is possible for the text
comprising the email body, footer, and
preheader text. This is done by using
curly braces to enclose R code chunks.
Variables can be specified in the function
call (using named arguments with \code{...}),
and any variables not found in \code{...}
will be searched for in the global
environment.
}
\examples{
# Create a simple email message using
# Markdown formatting
email <-
  compose_email(
  body = "
  Hello!

  ## This a section heading

  We can use Markdown formatting \\\\
  to **embolden** text or to add \\\\
  *emphasis*. This is exciting, \\\\
  right?

  Cheers")

# The email message can always be
# previewed using `preview_email()`
preview_email(email = email)

# We can use string interpolation to
# add in R code or strings assigned
# to variables; variables can be
# obtained from the global workspace
# or from temporary variables in the
# function call
sender_name <- "Mike"

email <-
  compose_email(
  body = "
  Hello!

  I just wanted to let you \\\\
  know that the {thing} that \\\\
  asked me for is ready to \\\\
  pick up. So, come over and \\\\
  do that.

  Cheers,

  {sender_name}",
  thing = "report")
}
