% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FarringtonManning.R
\name{toer,FarringtonManning-method}
\alias{toer,FarringtonManning-method}
\title{Type I Error Rate}
\usage{
\S4method{toer}{FarringtonManning}(
  design,
  n1,
  nuisance,
  recalculation,
  allocation = c("exact", "approximate"),
  ...
)
}
\arguments{
\item{design}{Object of class \code{FarringtonManning} created
by \code{setupFarringtonManning}.}

\item{n1}{Either the sample size of the first stage (if
\code{recalculation = TRUE} or the toal sample size (if
\code{recalculation = FALSE}).}

\item{nuisance}{Value of the nuisance parameter. For the
Farrington-Manning test this is the overall response rate.}

\item{recalculation}{Should the sample size be recalcuated after n1
patients are recruited?}

\item{allocation}{Whether the allocation ratio should be preserved
exactly (\code{exact}) or approximately (\code{approximate}).}

\item{...}{Further optional arguments.}
}
\value{
One type I error rate value for every nuisance parameter and every value of n1.
}
\description{
Computes the type I error rate of designs with blinded sample size recalculation
or of fixed designs for one or several values of the nuisance parameter.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.
}
\examples{
d <- setupFarringtonManning(alpha = 0.025, beta = 0.2, r = 1, delta = 0, delta_NI = 0.2)
toer(d, n1 = 20, nuisance = 0.25, recalculation = TRUE, allocation = "approximate")

}
