% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{compute_beta_posterior_density}
\alias{compute_beta_posterior_density}
\title{compute_beta_posterior_density}
\usage{
compute_beta_posterior_density(beta_sample, param, verbose = FALSE)
}
\arguments{
\item{beta_sample}{a matrix. Each row is a coefficient function computed from the
posterior sample.}

\item{param}{a list containing:
\describe{
\item{grid}{a numerical vector, the time points.}
\item{lims_estimate}{a numerical vector, the time points.}
\item{burnin}{an integer (optional), the number of iteration to drop from the Gibbs
      sample.}
\item{lims_kde}{an integer (optional), correspond to the \code{lims} option
      of the \code{kde2d} funtion.}
\item{new_grid}{a numerical vector (optional) to compute beta sample on a
      different grid.}
\item{thin}{an integer (optional) to thin the posterior sample.}
}}

\item{verbose}{write stuff if TRUE (optional).}
}
\value{
An approximation of the posterior density on a two-dimensional grid
        (corresponds to the result of the \code{\link[=kde2d]{kde2d}} function).
}
\description{
Compute the posterior density of the coefficient function.
}
\details{
The posterior densities correponds to approximations of the marginal
         posterior distribitions (of beta(t) for each t).
         The sample is thinned in order to reduce the correlation and the
         computational time of the function \code{\link[=kde2d]{kde2d}}.
}
\examples{
\donttest{
library(RColorBrewer)
data(data1)
data(param1)
# result of res_bliss1<-fit_Bliss(data=data1,param=param1)
data(res_bliss1)
q <- 1
param_beta_density <- list(grid= data1[["grids"]][[q]],
                           iter= param1[["iter"]],
                           p   = param1[["p"]][q],
                           n        = length(data1[["y"]]),
                           thin     = param1[["thin"]],
                           burnin   = param1[["burnin"]],
                           lims_kde = param1[["lims_kde"]][[q]],
                           new_grid = param1[["new_grids"]][[q]],
                           lims_estimate = range(res_bliss1$Smooth_estimate[[q]]))
density_estimate <- compute_beta_posterior_density(res_bliss1$beta_sample[[q]],param_beta_density)
image(density_estimate$grid_t,
      density_estimate$grid_beta_t,
      density_estimate$density,col=rev(heat.colors(100)))
}
}
