% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_yaml}
\alias{find_yaml}
\alias{find_tags}
\alias{find_categories}
\alias{count_yaml}
\title{Find posts containing the specified metadata}
\usage{
find_yaml(field = character(), value = character(), open = FALSE)

find_tags(value = character(), open = FALSE)

find_categories(value = character(), open = FALSE)

count_yaml(fields = c("categories", "tags"), sort_by_count = TRUE)
}
\arguments{
\item{field, fields}{A character vector of YAML field names.}

\item{value}{A vector of the field values to be matched.}

\item{open}{Whether to open the matched files automatically.}

\item{sort_by_count}{Whether to sort the frequency tables by counts.}
}
\value{
\code{find_yaml()} returns a character vector of filenames;
  \code{count_yaml()} returns a list of frequency tables.
}
\description{
Given a YAML field name, find the (R) Markdown files that contain this field
and its value contains any of the specified values. Functions
\code{find_tags()} and \code{find_categories()} are wrappers of
\code{find_yaml()} with \code{field = 'tags'} and \code{field =
'categories'}, respectively; \code{count_fields()} returns the frequency
tables of the specified YAML fields, such as the counts of tags and
categories.
}
\examples{
library(blogdown)
find_tags(c("time-series", "support vector machine"))
find_categories("Statistics")

count_yaml(sort_by_count = FALSE)
}
