% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{query_n_series}
\alias{query_n_series}
\title{Create a query to retrieve one or more time series and their catalog data}
\usage{
query_n_series(
  series,
  start_year = NA,
  end_year = NA,
  catalog = FALSE,
  calculations = FALSE,
  annualaverage = FALSE,
  aspects = FALSE
)
}
\arguments{
\item{series}{vector of BLS series IDs}

\item{start_year}{numeric 4-digit year}

\item{end_year}{numeric 4-digit year}

\item{catalog}{boolean}

\item{calculations}{boolean}

\item{annualaverage}{boolean}

\item{aspects}{boolean}
}
\value{
list of query parameters
}
\description{
Create a query to retrieve one or more time series and their catalog data
}
\examples{

a <- query_n_series(c('LNS14000001', 'LNS14000002'))
b <- query_n_series(c('LNS14000001', 'LNS14000002'), start_year = 2005, end_year=2010)
c <- query_n_series(c('LNS14000001', 'LNS14000002'), 2005, 2010)
d <- query_n_series(c('LNS14000001', 'LNS14000002'), catalog=TRUE)


}
\seealso{
Other blsR-queries: 
\code{\link{query_all_surveys}()},
\code{\link{query_latest_observation}()},
\code{\link{query_popular_series}()},
\code{\link{query_series}()},
\code{\link{query_survey_info}()}
}
\concept{blsR-queries}
