% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmc.R
\name{mmcLoss}
\alias{mmcLoss}
\title{Loss function for max-margin clustering}
\usage{
mmcLoss(x, k = 3L, minClusterSize = 1L, groups = matrix(logical(0),
  nrow(x), 0), minGroupOverlap = matrix(integer(0), k, ncol(groups)),
  weight = 1/nrow(x))
}
\arguments{
\item{x}{numeric matrix representing the dataset (one sample per row)}

\item{k}{an integer specifying number of clusters to find}

\item{minClusterSize}{an integer vector specifying the minimum number of sample per cluster. 
Given values are reclycled if necessary to have one value per cluster.}

\item{groups}{a logical matrix for instance grouping (groups[i,j] TRUE when 
sample i belong to group j).}

\item{minGroupOverlap}{an integer matrix specifyng the minimum number of instance
per cluster for each group.}

\item{weight}{a weight vector for each instance}
}
\value{
the loss function to optimize for max margin clustering of the given dataset
}
\description{
Loss function for max-margin clustering
}
