% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_convex.R
\name{preferenceLoss}
\alias{preferenceLoss}
\title{The loss function for Preference loss}
\usage{
preferenceLoss(x, P)
}
\arguments{
\item{x}{matrix of training instances (one instance by row)}

\item{P}{a data.frame with 3 fields (i,j,cost) that specify the cost for prefering sample j over sample i.}
}
\value{
a function taking one argument w and computing the loss value and the gradient at point w
}
\description{
The loss function for Preference loss
}
\examples{
x <- data.matrix(iris[1:4])
P <- expand.grid(i=which(iris$Species=="virginica"),j=which(iris$Species!="virginica"))
w <- nrbm(preferenceLoss(x,P),LAMBDA=0.001,EPSILON_TOL=0.0001)
}
\references{
Teo et al.
  Bundle Methods for Regularized Risk Minimization
  JMLR 2010
}
\seealso{
nrbm
}
