% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{relative.effects.table}
\alias{relative.effects.table}
\title{Make a summary table for relative effects}
\usage{
relative.effects.table(
  result,
  summary_stat = "mean",
  probs = NULL,
  base.category = NULL
)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}

\item{summary_stat}{Specifies what type of statistics user wants. Options are: "mean", "ci", "quantile", "sd", "p-value".
"ci" gives 95% confidence interval (0.025, 0.5, 0.975) and "quantile" gives specific quantile specified in probs parameter.
"p-value" is the probability relative effect (in binomial, log odds ratio) is less than 0.}

\item{probs}{Used only for the quantile summary. Specifies which quantile user wants the summary of (should be one numeric value between 0 to 1)}

\item{base.category}{Specifies for which base category user wants for the summary. Used only for multinoimal.}
}
\value{
Returns relative effects table
}
\description{
This function creates a summary table of relative effects. Relative effects are in units of log odds ratio for binomial and multinomial data and real number scale for normal data.
}
\examples{
#cardiovascular
network <- with(cardiovascular,{
 network.data(Outcomes, Study, Treat, N, response = "multinomial")
})
\donttest{
result <- network.run(network)
exp(relative.effects.table(result)) #look at odds ratio instead of log odds ratio
}
}
\seealso{
\code{\link{relative.effects}}
}
