% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeries.R
\name{get_monthly}
\alias{get_monthly}
\title{Get quality-checked timeseries data}
\usage{
get_monthly(
  parameter_type,
  station_number,
  start_date,
  end_date,
  tz,
  return_fields
)
}
\arguments{
\item{parameter_type}{The water data parameter type (e.g. Water Course
Discharge). See \code{\link{parameters()}} for a full list.}

\item{station_number}{The AWRC station number.}

\item{start_date}{Start date formatted as a string or date class
(YYYY-MM-DD).}

\item{end_date}{End date formatted as a string or date class (YYYY-MM-DD).}

\item{tz}{Optional: the desired time zone for the output timeseries. Input
must be an Olson Name (see \code{OlsonNames()}). By default the the timeseries
is returned in an offset timezone (e.g. \code{Etc/GMT-10} for NSW) as the
timeseries do not observe DST.}

\item{return_fields}{Optional: columns to be returned from Water Data Online.
By default Timestamp, Value and Quality Code are returned.}
}
\value{
A tibble with the requested return fields, which by default are
\code{Timestamp}, \code{Value} and \verb{Quality Code}. Zero row tibbles are returned if
no data is available for the requested dates. The aggregation of data is
generally the mean for most variables, except for rainfall and evaporation
which is the sum over the chosen period.
}
\description{
This function returns a quality-checked timeseries from
Water Data Online.
}
\details{
For the parameters (and their units) that can be requested, see
\link{parameters}. More information can be found in the Water Data Online
SOS manual (URL in See Also below).

Common valid return fields are:
\itemize{
\item Timestamp
\item Value
\item Quality Code
\item Interpolation Type
}

Other valid return fields (depending on the parameter requested) may be:
\itemize{
\item Absolute Value
\item AV Interpolation
\item AV Quality Code
\item Runoff Value
\item RV Interpolation
\item RV Quality Code
\item Aggregation
\item Accuracy
}

If the request is not valid it will fail.
}
\examples{
# Monthly average dry air temperature at Corin Dam
\dontrun{
get_monthly(
  parameter_type = "Dry Air Temperature",
  station_number = "570947",
  start_date = "2016-01-01",
  end_date = "2016-06-01"
)}
}
\seealso{
\itemize{
\item \url{http://www.bom.gov.au/waterdata/}
\item \href{http://www.bom.gov.au/waterdata/wiski-web-public/Guide\%20to\%20Sensor\%20Observation\%20Services\%20(SOS2)\%20for\%20Water\%20Data\%20\%20Online\%20v1.0.1.pdf}{BoM Guide to Sensor Observation Services (SOS2) for Water Data Online}
}
}
\author{
Alexander Buzacott
}
