% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangular_distribution.R
\name{triangular_distribution}
\alias{triangular_distribution}
\alias{triangular_pdf}
\alias{triangular_lpdf}
\alias{triangular_cdf}
\alias{triangular_lcdf}
\alias{triangular_quantile}
\title{Triangular Distribution Functions}
\usage{
triangular_pdf(x, lower = 0, mode = 1, upper = 2)

triangular_lpdf(x, lower = 0, mode = 1, upper = 2)

triangular_cdf(x, lower = 0, mode = 1, upper = 2)

triangular_lcdf(x, lower = 0, mode = 1, upper = 2)

triangular_quantile(p, lower = 0, mode = 1, upper = 2)
}
\arguments{
\item{x}{quantile}

\item{lower}{lower limit of the distribution (default is 0)}

\item{mode}{mode of the distribution (default is 1)}

\item{upper}{upper limit of the distribution (default is 2)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Triangular distribution.
}
\examples{
# Triangular distribution with lower = 0, mode = 1, upper = 2
triangular_pdf(1)
triangular_lpdf(1)
triangular_cdf(1)
triangular_lcdf(1)
triangular_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/dist_ref/dists/triangular_dist.html}{Boost Documentation} for more details on the mathematical background.
}
