% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootImpute.R
\name{bootImpute}
\alias{bootImpute}
\title{Bootstrap then impute an incomplete dataset}
\usage{
bootImpute(obsdata, impfun, nBoot = 200, nImp = 2, ...)
}
\arguments{
\item{obsdata}{The data frame to be imputed.}

\item{impfun}{A function which when passed an incomplete dataset will
return a single imputed data frame.}

\item{nBoot}{The number of bootstrap samples to take. It is recommended
that you use a minimum of 200.}

\item{nImp}{The number of times to impute each bootstrap sample. Two
is recommended.}

\item{...}{Other parameters that are to be passed through to \code{impfun}.}
}
\value{
A list of imputed datasets.
}
\description{
Bootstraps an incomplete dataset and then imputes each bootstrap a number
of times. The resulting list of bootstrapped then imputed datasets can
be analysed with \code{\link{bootImputeAnalyse}}.
}
\details{
The function can be used any kind of multiple imputation procedure. The
\code{impfun} must be a function which when passed an incomplete datasets
and possibly additional arguments, returns a single imputed data frame. Depending
on what imputation function returns by default, you may need to write a small
wrapper function that calls the imputation procedure once and returns the
imputed dataset. See the Example for an illustration with the \code{mice}
package.
}
\examples{
#this example shows how you can use bootImpute to impute using the mice
#package. If you do want to impute using MICE you can instead use the
#bootMice function, which essentially contains the code below
library(mice)

set.seed(564764)

#write a wrapper function to call mice with one imputation and return
#the imputed dataset
impOnce <- function(inputData) {
  oneImp <- mice::mice(inputData, m=1)
  mice::complete(oneImp)
}

#bootstrap twice and impute each twice
#in practice you should bootstrap many more times, e.g. at least 200
imps <- bootImpute(ex_linquad, impOnce, nBoot=2, nImp=2)
}
