% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{stability}
\alias{stability}
\title{Estimate clustering stability of k-means}
\usage{
stability(x, k, B = 20, r = 5, scheme_2 = TRUE)
}
\arguments{
\item{x}{a \code{data.frame} of the data set}

\item{k}{a \code{integer} number of clusters}

\item{B}{number of bootstrap re-samplings}

\item{r}{number of runs of k-means}

\item{scheme_2}{\code{logical} \code{TRUE} if scheme 2 is used, \code{FASLE} if scheme 1 is used}
}
\value{
\describe{
\item{\code{membership}}{a \code{vector} of membership for each observation from the reference clustering}
\item{\code{obs_wise}}{\code{vector} of estimated observation-wise stability}
\item{\code{overall}}{\code{numeric} estimated overall stability}
}
}
\description{
Estimate of k-means bootstrapping stability
}
\details{
This function estimates the clustering stability through bootstrapping approach. 
Two schemes are provided. Scheme 1 uses the clustering of the original data as the reference 
for stability calculations. Scheme 2 searches acrossthe clustering samples that gives the 
most stable clustering.
}
\examples{
 \dontrun{
set.seed(1)
data(wine)
x0 <- wine[,2:14]
x <- scale(x0)
stability(x, k = 3, B=20, r=5, scheme_2 = TRUE)
}
}
\references{
Bootstrapping estimates of stability for clusters, observations and model selection.
Han Yu, Brian Chapman, Arianna DiFlorio, Ellen Eischen, David Gotz, Matthews Jacob and Rachael Hageman Blair.
}
\author{
Han Yu
}
