	doCV <- function(logX, groupings, ## data and grouping
				fs.methods=c("pamr","scad","rf_boruta"), ## method selection
				DIR="cv", ## output directory
				seed=123, ncv=5, repeats=10, jitter=FALSE,## general parameters
				maxiter=1000, maxevals=500, ## scad parameters
				max_allowed_feat=500, n.threshold=50, ## pamr parameters
				maxRuns=300) { ## rf boruta parameters
		## check if correct method namings are passed
		stopifnot(all(fs.methods %in% c("pamr", "scad", "rf_boruta")))
		#stopifnot(require(ROCR))
		
		if(!file.exists(DIR))
			dir.create(DIR)

		## create parameter objects for the different methods
		paramsPAMR <- list(seed=seed, ncv=ncv, repeats=repeats, max_allowed_feat=max_allowed_feat, n.threshold=n.threshold, jitter=jitter)
		paramsSCAD <- list(seed=seed, ncv=ncv, repeats=repeats, maxevals=maxevals, maxiter=maxiter, jitter=jitter)
		paramsRFBORUTA <- list(seed=seed, ncv=ncv, repeats=repeats, maxRuns=maxRuns, jitter=jitter)

		## run the CVs
		results <- list()
		for(i in 1:length(fs.methods)) {
			if(fs.methods[i]=="pamr") {
				results[["pamr"]] <- cvPAMR(logX, groupings, DIR, paramsPAMR)
			} else if(fs.methods[i]=="scad") {
				results[["scad"]] <- cvSCAD(logX, groupings, DIR, paramsSCAD)
			} else if(fs.methods[i]=="rf_boruta") {
				results[["rf_boruta"]] <- cvRFBORUTA(logX, groupings, DIR, paramsRFBORUTA)
			}
		}
		results
	}
