% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{s3_download_file}
\alias{s3_download_file}
\title{Download a file from S3}
\usage{
s3_download_file(uri, file, force = TRUE)
}
\arguments{
\item{uri}{string, URI of an S3 object, should start with \code{s3://}, then bucket name and object key}

\item{file}{string, location of local file}

\item{force}{boolean, overwrite local file if exists}
}
\value{
invisibly \code{file}
}
\description{
Download a file from S3
}
\examples{
\dontrun{
s3_download_file('s3://botor/example-data/mtcars.csv', tempfile())
}
}
\references{
\url{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/s3.html#S3.Client.download_file}
}
