% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_file_versions.R
\name{box_previous_versions}
\alias{box_previous_versions}
\title{Get details of previous versions of a Box file}
\usage{
box_previous_versions(file_id)
}
\arguments{
\item{file_id}{\code{numeric} or \code{character}, file ID at Box.}
}
\value{
\code{data.frame} containing information about previous
versions of the file (if available).
}
\description{
Box explicitly versions files; this function returns a
\code{data.frame} containing information on a file's previous
versions on Box. No information about the current version of the file is
returned.
}
\details{
The returned \code{data.frame} contains a variable, \code{file_version_id},
which you can use with \code{\link[=box_dl]{box_dl()}}.
}
\references{
This function is a light wrapper of the
\href{https://developer.box.com/docs}{box.com} API \code{versions} method.

\url{https://developers.box.com/docs/#files-view-versions-of-a-file}
}
\seealso{
\code{\link[=box_dl]{box_dl()}}
}
