% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_write.R
\name{box_write}
\alias{box_write}
\title{Write an R object to a Box file}
\usage{
box_write(x, file_name, dir_id = box_getwd(), description = NULL,
  write_fun = rio::export, filename, ...)
}
\arguments{
\item{x}{Object to be written.}

\item{file_name}{\code{character}, name of the new Box file.}

\item{dir_id}{\code{numeric} or \code{character}, folder ID at Box.}

\item{description}{\code{character}, description caption for the file.}

\item{write_fun}{\code{function}, used to write (serialize) the content from R;
default function is \code{\link[rio:export]{rio::export()}}.}

\item{filename}{\code{character}, \strong{deprecated}: use \code{file_name} instead.}

\item{...}{Other arguments passed to \code{write_fun}.}
}
\value{
Object with S3 class \code{\link[=boxr_S3_classes]{boxr_file_reference}}.
}
\description{
This function is used to serialize an R object and write it
to a Box file. For example, you may wish to write a \code{data.frame}
to Box as a CSV file.
}
\details{
This is a two-step process. The first is to serialize the contents
of the R object, the second is to upload that serialization to a Box file.
The default serialization-function is \code{\link[rio:export]{rio::export()}}.

The \code{\link[rio:export]{rio::export()}} function currently only
supports \code{data.frame}; to serialize lists, you may wish to use
\code{\link[jsonlite:toJSON]{jsonlite::toJSON()}}.

Please note that \code{box_write()} is used to write R objects to Box files
using standard formats. To write R objects as \code{.RData} files,
you can use \code{\link[=box_save]{box_save()}}.
}
