% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{traceplot.bpnr}
\alias{traceplot.bpnr}
\title{Traceplots for a Bayesian circular regression model}
\usage{
\method{traceplot}{bpnr}(object, parameter = "SAM", variable = NULL)
}
\arguments{
\item{object}{a \code{bpnr object} obtained from the function
\code{\link{bpnr}}}

\item{parameter}{one of \code{c("B1", "B2", "a.x", "a.c", "b.c", "SAM", "AS",
"SSDO", "circ.diff")} to indicate for which parameter a traceplot is
required. \code{B1} and \code{B2} are the linear intercepts and
coefficients of the first and second component. \code{circ.diff} are the
circular differences with the intercept on the outcome variable for the
different levels of categorical variables.}

\item{variable}{a character string with variable name(s) to indicate for
which variable(s) a traceplot is required.}
}
\description{
General plot function for a \code{bpnr object}.
}
\examples{
library(bpnreg)
fit.Motor <- bpnr(pred.I = Phaserad ~ 1 + Cond, data = Motor,
its = 100, burn = 10, n.lag = 3)
traceplot(fit.Motor, parameter = "B1")

}
