% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_prune.R
\name{model.lp}
\alias{model.lp}
\title{Estimating change-points in the piecewise-constant mean of a noisy data sequence via the localised pruning}
\usage{
model.lp(
  cptpath.object,
  min.d = 5,
  penalty = c("log", "polynomial")[1],
  pen.exp = 1.01,
  do.thr = TRUE,
  th.const = 0.5
)
}
\arguments{
\item{cptpath.object}{A solution-path object, returned by a \code{sol.[name]} routine. Note that the field \code{cptpath.object$x} contains the input data sequence.}

\item{min.d}{A number specifying the minimal spacing between change points; \code{min.d = 5} by default}

\item{penalty}{A string specifying the type of penalty term to be used in Schwarz criterion; possible values are:
\itemize{
   \item{\code{"log"}}{ Use \code{penalty = log(length(x))^pen.exp}}
   \item{\code{"polynomial"}}{ Use \code{penalty = length(x)^pen.exp}}
}}

\item{pen.exp}{Exponent for the penalty term (see \code{penalty})}

\item{do.thr}{If \code{do.thr = TRUE}, mild threshoding on the CUSUM test statistics is performed after internal standardisation step in order to "pre-prune down" the candidates}

\item{th.const}{A constant multiplied to \code{sqrt(2*log(length(x)))} to form a mild threshold; if not supplied, a default value (\code{0.5*} a value suggested in Fryzlewicz (2020) is used,
see \code{th.const} in \code{\link{model.sdll}}}
}
\value{
An S3 object of class \code{cptmodel}, which contains the following fields: 
\item{solution.path}{The solution path method used to obtain \code{cptpath.object}}
\item{model}{The model selection method used to return the final change-point estimators object, here its value is \code{"ip"}}
\item{no.of.cpt}{The number of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}}
\item{cpts}{The locations of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}. These are the end-points of the corresponding constant-mean intervals}
\item{est}{An estimate of the piecewise-constant mean of the vector \code{cptpath.object$x}; the values are the sample means of the data (replicated a suitable number of times) between each pair of consecutive detected change-points}
}
\description{
This function estimates the number and locations of change-points in the piecewise-constant mean of a noisy data sequence via the localised pruning method, which performs a Schwarz criterion-based model selection on the given candidate set in a localised way.
}
\details{
Further information can be found in Cho and Kirch (2020), arXiv preprint arXiv:1910.12486.
}
\examples{
f <- rep(rep(c(0, 1), each = 50), 10)
x <- f + rnorm(length(f))
model.lp(sol.not(x))
}
\references{
H. Cho & C. Kirch (2020) Two-stage data segmentation permitting multiscale change points, heavy tails and dependence. \emph{arXiv preprint arXiv:1910.12486}.
}
\seealso{
\code{\link{sol.idetect}}, \code{\link{sol.idetect_seq}}, \code{\link{sol.not}}, \code{\link{sol.tguh}}, \code{\link{sol.wbs}}, \code{\link{sol.wbs2}}, \code{\link{breakfast}}
}
