% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/support.export.R
\name{brm.data}
\alias{brm.data}
\title{Extract required data for \code{brms} models}
\usage{
brm.data(formula, data = NULL, family = "gaussian", prior = list(),
  autocor = NULL, partial = NULL, cov.ranef = NULL)
}
\arguments{
\item{formula}{An object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.
The details of model specification are given under 'Details'.}

\item{data}{An optional data frame, list or environment  (or object coercible by \code{as.data.frame} to a data frame) containing
the variables in the model. If not found in data, the variables are taken from \code{environment(formula)},
typically the environment from which \code{brm} is called.}

\item{family}{A vector of one or two character strings. The first string indicates the distribution of the dependent variable (the 'family'). Currently, the following families are supported:
\code{"gaussian"}, \code{"student"}, \code{"cauchy"}, \code{"multigaussian"}, \code{"binomial"}, \code{"bernoulli"}, \code{"categorical"}, \code{"poisson"}, \code{"negbinomial"}, \cr
\code{"geometric"}, \code{"gamma"}, \code{"exponential"}, \code{"weibull"}, \code{"cumulative"}, \code{"cratio"}, \code{"sratio"}, and \code{"acat"}.
The second string indicates the link function, which must be supported by the distribution of the dependent variable.
If not specified, default link functions are used. Further information is provided under 'Details'.}

\item{prior}{A named list of character strings specifing the prior distributions of the parameters. Further information
is provided under 'Details'.}

\item{autocor}{An optional \code{\link{cor.brms}} object describing the correlation structure within the response variable (i.e. the 'autocorrelation').
See the documentation of \code{\link{cor.brms}} for a description of the available correlation structures.
Defaults to NULL, corresponding to no correlations.}

\item{partial}{A one sided formula of the form \code{~partial.effects} specifing the predictors that can vary between categories in non-cumulative ordinal models
(i.e. in families \code{"cratio"}, \code{"sratio"}, or \code{"acat"}).}

\item{cov.ranef}{A list of matrices that are proportional to the (within) covariance structure of the random effects.
The names of the matrices should correspond to columns in \code{data} that are used as grouping factors.
All levels of the grouping factor should appear as rownames of the corresponding matrix.
Currently, customized covariance structures are only implemented for grouping factors with a single random effect.}
}
\value{
A named list of objects containing the required data to fit a \code{brms} model
}
\description{
Extract required data for \code{brms} models
}
\examples{
data1 <- brm.data(rating ~ treat + period + carry + (1|subject),
                  data = inhaler, family = "cumulative")
names(data1)

data2 <- brm.data(count ~ log_Age_c + log_Base4_c * Trt_c + (1|patient) + (1|visit),
                  data = epilepsy, family = "poisson")
names(data2)
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

