% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_add_pairwise_contrasts.R
\name{tidy_add_pairwise_contrasts}
\alias{tidy_add_pairwise_contrasts}
\title{Add pairwise contrasts for categorical variables}
\usage{
tidy_add_pairwise_contrasts(
  x,
  variables = all_categorical(),
  keep_model_terms = FALSE,
  pairwise_reverse = TRUE,
  contrasts_adjust = NULL,
  conf.level = NULL,
  emmeans_args = list(),
  model = tidy_get_model(x),
  quiet = FALSE
)
}
\arguments{
\item{x}{a tidy tibble}

\item{variables}{a vector indicating the name of variables
for those pairwise contrasts should be added.
Accepts \link[dplyr:select]{tidyselect} syntax. Default is  \code{\link[=all_categorical]{all_categorical()}}}

\item{keep_model_terms}{keep terms from the model?}

\item{pairwise_reverse}{determines whether to use \code{"pairwise"} (if \code{TRUE})
or \code{"revpairwise"} (if \code{FALSE}), see \code{\link[emmeans:contrast]{emmeans::contrast()}}}

\item{contrasts_adjust}{optional adjustment method when computing contrasts,
see \code{\link[emmeans:contrast]{emmeans::contrast()}} (if \code{NULL}, use \code{emmeans} default)}

\item{conf.level}{confidence level, if \code{NULL} use the value indicated
previously in \code{\link[=tidy_and_attach]{tidy_and_attach()}}}

\item{emmeans_args}{list of additional parameter to pass to
\code{\link[emmeans:emmeans]{emmeans::emmeans()}} when computing pairwise contrasts}

\item{model}{the corresponding model, if not attached to \code{x}}

\item{quiet}{logical argument whether broom.helpers should not return
a message when requested output cannot be generated. Default is \code{FALSE}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Computes pairwise contrasts with \code{\link[emmeans:emmeans]{emmeans::emmeans()}} and add them to the
results tibble. Works only with models supported by \code{emmeans}, see
\code{vignette("models", package = "emmeans")}.
}
\note{
If the \code{contrasts} column is not yet available in \code{x},
\code{\link[=tidy_add_contrasts]{tidy_add_contrasts()}} will be automatically applied.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (.assert_package("emmeans", boolean = TRUE)) {
  mod1 <- lm(Sepal.Length ~ Species, data = iris)
  mod1 \%>\%
    tidy_and_attach() \%>\%
    tidy_add_pairwise_contrasts()

  mod1 \%>\%
    tidy_and_attach() \%>\%
    tidy_add_pairwise_contrasts(pairwise_reverse = FALSE)

  mod1 \%>\%
    tidy_and_attach() \%>\%
    tidy_add_pairwise_contrasts(keep_model_terms = TRUE)

  mod1 \%>\%
    tidy_and_attach() \%>\%
    tidy_add_pairwise_contrasts(contrasts_adjust = "none")

  if (.assert_package("gtsummary", boolean = TRUE)) {
    mod2 <- glm(
      response ~ age + trt + grade,
      data = gtsummary::trial,
      family = binomial
    )
    mod2 \%>\%
      tidy_and_attach(exponentiate = TRUE) \%>\%
      tidy_add_pairwise_contrasts()
  }
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
