% Generated by roxygen2 (4.0.2): do not edit by hand
\name{smooth.spline_tidiers}
\alias{augment.smooth.spline}
\alias{glance.smooth.spline}
\alias{smooth.spline_tidiers}
\title{tidying methods for smooth.spline objects}
\usage{
\method{augment}{smooth.spline}(x, data = x$data, ...)

\method{glance}{smooth.spline}(x, ...)
}
\arguments{
\item{x}{a smooth.spline object}

\item{data}{defaults to data used to fit model}

\item{...}{not used in this method}
}
\value{
\code{augment} returns the original data with extra columns:
  \item{.fitted}{Fitted values of model}
  \item{.resid}{Residuals}

\code{glance} returns one row with columns
  \item{spar}{smoothing parameter}
  \item{lambda}{choice of lambda corresponding to \code{spar}}
  \item{df}{equivalent degrees of freedom}
  \item{crit}{minimized criterion}
  \item{pen.crit}{penalized criterion}
  \item{cv.crit}{cross-validation score}
}
\description{
This combines the original data given to smooth.spline with the
fit and residuals
}
\details{
No \code{tidy} method is provided for smooth.spline objects.
}
\examples{
spl <- smooth.spline(mtcars$wt, mtcars$mpg, df = 4)
head(augment(spl, mtcars))
head(augment(spl))  # calls original columns x and y

library(ggplot2)
ggplot(augment(spl, mtcars), aes(wt, mpg)) +
    geom_point() + geom_line(aes(y = .fitted))
}

