% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bingroup_tidiers.R
\name{binDesign_tidiers}
\alias{binDesign_tidiers}
\alias{glance.binDesign}
\alias{tidy.binDesign}
\title{Tidy a binDesign object}
\usage{
\method{tidy}{binDesign}(x, ...)

\method{glance}{binDesign}(x, ...)
}
\arguments{
\item{x}{A "binDesign" object}

\item{...}{Extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

The \code{tidy} method returns a data.frame
with one row for each iteration that was performed,
with columns
    \item{n}{Number of trials in this iteration}
    \item{power}{The power achieved for this n}

The \code{glance} method returns a one-row data.frame
with columns
    \item{power}{The power achieved by the analysis}
    \item{n}{The sample size used to achieve this power}
    \item{power.reached}{Whether the desired power was reached}
    \item{maxit}{Number of iterations performed}
}
\description{
Tidy a binDesign object from the "binGroup" package,
which determines the sample size needed for
a particular power.
}
\examples{
if (require("binGroup", quietly = TRUE)) {
    des <- binDesign(nmax = 300, delta = 0.06,
                     p.hyp = 0.1, power = .8)

    glance(des)
    head(tidy(des))

    # the ggplot2 equivalent of plot(des)
    library(ggplot2)
    ggplot(tidy(des), aes(n, power)) +
        geom_line()
}
}

