% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated-0-7-0.R
\name{tidy.dist}
\alias{tidy.dist}
\title{(Deprecated) Tidy dist objects}
\usage{
\method{tidy}{dist}(x, diagonal = attr(x, "Diag"), upper = attr(x, "Upper"), ...)
}
\arguments{
\item{x}{A \code{dist} object returned from \code{\link[stats:dist]{stats::dist()}}.}

\item{diagonal}{Logical indicating whether or not to tidy the diagonal
elements of the distance matrix. Defaults to whatever was based to the
\code{diag} argument of \code{\link[stats:dist]{stats::dist()}}.}

\item{upper}{Logical indicating whether or not to tidy the upper half of
the distance matrix. Defaults to whatever was based to the
\code{upper} argument of \code{\link[stats:dist]{stats::dist()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.level = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row for each pair of items in the
distance matrix, with columns:

\item{item1}{First item}
\item{item2}{Second item}
\item{distance}{Distance between items}
}
\description{
(Deprecated) Tidy dist objects
}
\details{
If the distance matrix does not include an upper triangle and/or
diagonal, the tidied version will not either.
}
\examples{

cars_dist <- dist(t(mtcars[, 1:4]))
cars_dist

tidy(cars_dist)
tidy(cars_dist, upper = TRUE)
tidy(cars_dist, diagonal = TRUE)

}
\seealso{
Other deprecated: 
\code{\link{bootstrap}()},
\code{\link{confint_tidy}()},
\code{\link{data.frame_tidiers}},
\code{\link{finish_glance}()},
\code{\link{fix_data_frame}()},
\code{\link{summary_tidiers}},
\code{\link{tidy.density}()},
\code{\link{tidy.ftable}()},
\code{\link{tidy.gamlss}()},
\code{\link{tidy.numeric}()}
}
\concept{deprecated}
