% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylomatic_local.R
\name{phylomatic_local}
\alias{phylomatic_local}
\title{Use Phylomatic locally - ideal for large queries}
\usage{
phylomatic_local(taxa, taxnames = TRUE, storedtree = "R20120829",
  db = "apg", lowercase = FALSE, nodes = FALSE, verbose = TRUE)
}
\arguments{
\item{taxa}{(character) Phylomatic format input of taxa names. required}

\item{taxnames}{If \code{TRUE} (default), we get the family names for you
to attach to your species names to send to Phylomatic API. If \code{FALSE},
you have to provide the strings in the right format. See Details.}

\item{storedtree}{One of R20120829 (Phylomatic tree R20120829 for plants),
smith2011 (Smith 2011, plants), binindaemonds2007 (Bininda-Emonds 2007,
mammals), or zanne2014 (Zanne et al. 2014, plants). Default: R20120829}

\item{db}{(character) One of "ncbi", "itis", or "apg". Default: apg}

\item{lowercase}{(logical) Convert all chars in taxa file to lowercase.
Default: \code{FALSE}}

\item{nodes}{(logical) label all nodes with default names.
Default: \code{FALSE}}

\item{verbose}{(logical) Print messages. Default: \code{TRUE}}
}
\value{
Newick formatted tree as \code{phylo} object
}
\description{
Use Phylomatic locally - ideal for large queries
}
\details{
uses \code{\link[phylocomr:ph_phylomatic]{phylocomr::ph_phylomatic()}} under the hood

This function uses Phylomatic via Phylocom using the
\pkg{phylocomr} package. The interface is slightly different from
\code{\link[=phylomatic]{phylomatic()}}: there's no tree by URL available, and some of the
parameters are not included here.

If you set \code{taxnames = FALSE}, you need to pass in a character
vector, with each element like this example:
\code{"asteraceae/taraxacum/taraxacum_officinale"}, of the form
\code{"family/genus/genus_specfic epithet"}
}
\examples{
\dontrun{
library('ape')

# Input taxonomic names
taxa <- c("Poa annua", "Phlox diffusa", "Helianthus annuus")
(tree <- phylomatic_local(taxa))
plot(collapse.singles(tree), no.margin=TRUE)

taxa <- c("Poa annua", "Collomia grandiflora", "Lilium lankongense",
"Phlox diffusa", "Iteadaphne caudata", "Gagea sarmentosa",
"Helianthus annuus")
(tree <- phylomatic_local(taxa))
plot(collapse.singles(tree), no.margin=TRUE)

library("taxize")
spp <- names_list("species", 500)
length(spp)
(tree <- phylomatic_local(spp))
}
}
