% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_theme.R
\name{theme_bruce}
\alias{theme_bruce}
\title{A nice \code{ggplot2} theme for scientific publication.}
\usage{
theme_bruce(
  base.size = 12,
  line.size = 0.5,
  border = "black",
  bg = "white",
  panel.bg = "white",
  tag = "bold",
  plot.title = "bold",
  axis.title = "plain",
  title.pos = 0.5,
  subtitle.pos = 0.5,
  caption.pos = 1,
  font = NULL,
  grid.x = "",
  grid.y = "",
  line.x = TRUE,
  line.y = TRUE,
  tick.x = TRUE,
  tick.y = TRUE
)
}
\arguments{
\item{base.size}{Basic font size. Default is 12.}

\item{line.size}{Line width. Default is 0.5.}

\item{border}{\code{TRUE}, \code{FALSE}, or \code{"black"} (default).}

\item{bg}{Background color of whole plot. Default is \code{"white"}.
You can use any colors or choose from some pre-set color palettes:
\code{"stata", "stata.grey", "solar", "wsj", "light", "dust"}.

To see these colors, you can type:

\code{ggthemr::colour_plot(c(stata="#EAF2F3", stata.grey="#E8E8E8",
solar="#FDF6E3", wsj="#F8F2E4", light="#F6F1EB", dust="#FAF7F2"))}}

\item{panel.bg}{Background color of panel. Default is \code{"white"}.}

\item{tag}{Font face of tag. Choose from \code{"plain", "italic", "bold", "bold.italic"}.}

\item{plot.title}{Font face of title. Choose from \code{"plain", "italic", "bold", "bold.italic"}.}

\item{axis.title}{Font face of axis text. Choose from \code{"plain", "italic", "bold", "bold.italic"}.}

\item{title.pos}{Title position (0~1).}

\item{subtitle.pos}{Subtitle position (0~1).}

\item{caption.pos}{Caption position (0~1).}

\item{font}{Text font. Only applicable to Windows system.}

\item{grid.x}{\code{FALSE}, \code{""} (default), or a color (e.g., \code{"grey90"}) to set the color of panel grid (x).}

\item{grid.y}{\code{FALSE}, \code{""} (default), or a color (e.g., \code{"grey90"}) to set the color of panel grid (y).}

\item{line.x}{\code{TRUE} (default) or \code{FALSE}. Whether to draw the x-axis line.}

\item{line.y}{\code{TRUE} (default) or \code{FALSE}. Whether to draw the y-axis line.}

\item{tick.x}{\code{TRUE} (default) or \code{FALSE}. Whether to draw the x-axis ticks.}

\item{tick.y}{\code{TRUE} (default) or \code{FALSE}. Whether to draw the y-axis ticks.}
}
\value{
A theme object that should be used for \code{ggplot2}.
}
\description{
A nice \code{ggplot2} theme for scientific publication.
}
\examples{
## Example 1 (bivariate correlation)
d=as.data.table(bfi)
d[,":="(E=MEAN(d, "E", 1:5, rev=c(1,2), likert=1:6),
        O=MEAN(d, "O", 1:5, rev=c(2,5), likert=1:6))]
ggplot(data=d, aes(x=E, y=O)) +
  geom_point(alpha=0.1) +
  geom_smooth(method="loess") +
  labs(x="Extraversion", y="Openness") +
  theme_bruce()

## Example 2 (2x2 ANOVA)
d=data.frame(X1=factor(rep(1:3, each=2)),
             X2=factor(rep(1:2, 3)),
             Y.mean=c(5, 3, 2, 7, 3, 6),
             Y.se=rep(c(0.1, 0.2, 0.1), each=2))
ggplot(data=d, aes(x=X1, y=Y.mean, fill=X2)) +
  geom_bar(position="dodge", stat="identity", width=0.6, show.legend=FALSE) +
  geom_errorbar(aes(x=X1, ymin=Y.mean-Y.se, ymax=Y.mean+Y.se),
                width=0.1, color="black", position=position_dodge(0.6)) +
  scale_y_continuous(expand=expansion(add=0),
                     limits=c(0,8), breaks=0:8) +
  scale_fill_brewer(palette="Set1") +
  labs(x="Independent Variable", y="Dependent Variable", title="Demo") +
  theme_bruce(border="")

}
