% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_basic.R
\name{LOOKUP}
\alias{LOOKUP}
\title{Search, match, and look up values (like Excel's functions \code{INDEX + MATCH}).}
\usage{
LOOKUP(
  data,
  vars,
  data.ref,
  vars.ref,
  vars.lookup,
  return = c("new.data", "new.var", "new.value")
)
}
\arguments{
\item{data}{Main data.}

\item{vars}{Character (vector), specifying the variable(s) to be searched in \code{data}.}

\item{data.ref}{Reference data containing both the reference variable(s) and the lookup variable(s).}

\item{vars.ref}{Character (vector), with the \strong{same length and order} as \code{vars},
specifying the reference variable(s) to be matched in \code{data.ref}.}

\item{vars.lookup}{Character (vector), specifying the variable(s) to be looked up and returned from \code{data.ref}.}

\item{return}{What to return. Default (\code{"new.data"}) is to return a data frame with the lookup values added.
You may also set it to \code{"new.var"} or \code{"new.value"}.}
}
\value{
New data object, new variable, or new value (see the argument \code{return}).
}
\description{
In Excel, we can use \code{VLOOKUP}, \code{HLOOKUP}, \code{XLOOKUP} (a new function released in 2019),
or the combination of \code{INDEX} and \code{MATCH} to search, match, and look up values.
Here I provide a similar function.
}
\details{
If multiple values were simultaneously matched, a warning message would be printed.
}
\examples{
ref=data.table(City=rep(c("A", "B", "C"), each=5),
               Year=rep(2013:2017, times=3),
               GDP=sample(1000:2000, 15),
               PM2.5=sample(10:300, 15))
ref

data=data.table(sub=1:5,
                city=c("A", "A", "B", "C", "C"),
                year=c(2013, 2014, 2015, 2016, 2017))
data

LOOKUP(data, c("city", "year"), ref, c("City", "Year"), "GDP")
LOOKUP(data, c("city", "year"), ref, c("City", "Year"), c("GDP", "PM2.5"))

}
\seealso{
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}}

\href{https://www.excel-university.com/xlookup/}{XLOOKUP: Excel University}
}
