% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcov.R
\name{bcov}
\alias{bcov}
\title{bcov: Bayesian Estimation of the Variance Covariance Matrix}
\usage{
bcov(data, iter, burn, seed, CI, S0, nu0, mu0)
}
\arguments{
\item{data}{N by P data matrix.}

\item{iter}{Number of iterations for the Gibbs sampler.}

\item{burn}{Number of samples to burn in.}

\item{seed}{Seed for the Gibbs sampler}

\item{CI}{Credible interval quantile, as a decimal (ie, for 95 percent, 0.95).}

\item{S0}{Prior variance covariance matrix.}

\item{nu0}{Prior degrees of freedom for inverse Wishart prior distribution.

#'@import MCMCpack}

\item{mu0}{Prior means for each column.}
}
\value{
Returns median posterior estimates of the variance covariance matrix.
}
\description{
This function estimates the variance covariance matrix for a
}
\examples{
set.seed(999)
your_data=mvrnorm(n=15,mu=c(0,0),Sigma=matrix(c(4,3,3,9),nrow=2,ncol=2))
Mu0=c(0,0)
Sigma0=matrix(c(1,0.6,0.6,4),nrow=2,ncol=2)
Nu0=3-1
bcor(data=your_data,iter=5000,burn=2500,seed=999,CI=0.95,
    mu0=Mu0,S0=Sigma0,nu0=Nu0)

}
