% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Jumbotron}
\alias{bs4Jumbotron}
\title{BS4 jumbotron for AdminLTE3}
\usage{
bs4Jumbotron(
  ...,
  title = NULL,
  lead = NULL,
  href = NULL,
  btn_name = "More",
  status = c("primary", "warning", "danger", "info", "success")
)
}
\arguments{
\item{...}{Any content.}

\item{title}{Jumbotron title.}

\item{lead}{Jumbotron lead.}

\item{href}{Jumbrotron external link.}

\item{btn_name}{Jumbotron button name.}

\item{status}{Jumbotron background color. "primary", "success", "warning", "danger" or "info".}
}
\description{
Create a jumbotron
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      bs4Jumbotron(
      title = "Hello, world!",
      lead = "This is a simple hero unit, a simple jumbotron-style 
      component for calling extra attention to featured 
      content or information.",
      "It uses utility classes for typography and spacing 
      to space content out within the larger container.",
      status = "primary",
      href = "http://www.google.fr"
      )
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
