% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardSidebar.R
\name{updatebs4Sidebar}
\alias{updatebs4Sidebar}
\title{Function to programmatically toggle the state of the sidebar}
\usage{
updatebs4Sidebar(inputId, session)
}
\arguments{
\item{inputId}{Sidebar id.}

\item{session}{Shiny session object.}
}
\description{
Function to programmatically toggle the state of the sidebar
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = dashboardPage(
     controlbar_collapsed = FALSE,
     controlbar_overlay = TRUE,
     navbar = dashboardHeader(),
     sidebar = dashboardSidebar(inputId = "sidebar"),
     body = dashboardBody(
       actionButton(inputId = "controlbarToggle", label = "Toggle Sidebar")
     )
   ),
   server = function(input, output, session) {
     
     observeEvent(input$sidebar, {
       if (input$sidebar) {
         showModal(modalDialog(
           title = "Alert",
           "The sidebar is opened.",
           easyClose = TRUE,
           footer = NULL
         ))
       }
     })
     
     observeEvent(input$controlbarToggle, {
       updatebs4Sidebar(inputId = "sidebar", session = session)
     })
     
     observe({
       print(input$sidebar)
     })
   }
 )
}
}
