% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{actionButton}
\alias{actionButton}
\title{Bootstrap 4 Action button/link}
\usage{
actionButton(
  inputId,
  label,
  icon = NULL,
  width = NULL,
  ...,
  status = NULL,
  gradient = FALSE,
  outline = FALSE,
  size = NULL,
  flat = FALSE
)
}
\arguments{
\item{inputId}{The `input` slot that will be used to access the value.}

\item{label}{The contents of the button or link--usually a text label, but
you could also use any other HTML, like an image.}

\item{icon}{An optional [icon()] to appear on the button.}

\item{width}{The width of the input, e.g. `'400px'`, or `'100%'`;
see [validateCssUnit()].}

\item{...}{Named attributes to be applied to the button or link.}

\item{status}{Button status color. Valid statuses are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
}}

\item{gradient}{Whether to apply gradient to color. Default to FALSE.}

\item{outline}{Whether to display an outline style. Status must not be NULL if TRUE. Default to
FALSE.}

\item{size}{Button size. Default to NULL. Possible choices: \code{c("lg", "sm", "xs")}.}

\item{flat}{Whether to apply a flat style. Default to FALSE.}
}
\description{
Creates an action button or link whose value is initially zero, and increments by one
each time it is pressed.
}
\note{
One may also pass the status directly via the ... parameter using \code{class = "btn-primary"},
for the primary status for instance. Same thing for other styles like the size.
}
\section{Server value}{

An integer of class `"shinyActionButtonValue"`. This class differs from
ordinary integers in that a value of 0 is considered "falsy".
This implies two things:
  * Event handlers (e.g., [observeEvent()], [eventReactive()]) won't execute on initial load.
  * Input validation (e.g., [req()], [need()]) will fail on initial load.
}

\examples{
## Only run examples in interactive R sessions
if (interactive()) {
 library(shiny)
 library(bs4Dash)

 shinyApp(
  ui = dashboardPage(
    header = dashboardHeader(
      title = bs4DashBrand(
        title = "My dashboard",
        color = "primary",
        src = "https://adminlte.io/themes/v3",
        image = "https://adminlte.io/themes/v3/dist/img/AdminLTELogo.png"
      )
    ),
    sidebar = dashboardSidebar(),
    body = dashboardBody(
      sliderInput("obs", "Number of observations", 0, 1000, 500),
      actionButton(
       "goButton", "Go!", 
       status = "danger", 
       outline = TRUE, 
       flat = TRUE, 
       size = "lg"
      ),
     plotOutput("distPlot")
    ),
    controlbar = dashboardControlbar(),
    title = "DashboardPage"
  ),
  server = function(input, output) {
   output$distPlot <- renderPlot({
    # Take a dependency on input$goButton. This will run once initially,
    # because the value changes from NULL to 0.
    input$goButton

    # Use isolate() to avoid dependency on input$obs
    dist <- isolate(rnorm(input$obs))
    hist(dist)
   })
  }
 )

}

## Example of adding extra class values
actionButton("largeButton", "Large Primary Button", class = "btn-primary btn-lg")

}
\seealso{
[observeEvent()] and [eventReactive()]
}
\concept{input elements}
