% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{shinyInput_label_embed}
\alias{shinyInput_label_embed}
\title{Embed an element into the label of a Shiny-input tag}
\usage{
shinyInput_label_embed(tag, element)
}
\arguments{
\item{tag}{Shiny input, such as \code{shiny::\link[shiny]{numericInput}}}

\item{element}{\code{htmltools::\link[htmltools]{tag}} to be embedded
into label of \code{tag}}
}
\value{
Shiny input, modified copy of \code{tag}
}
\description{
The element embedded into the Shiny input will be pulled to the
right edge of the label.
}
\details{
To promote consistency, the following convention is proposed:

For links (activated by clicking), embed a \code{shiny::icon("info-circle")};
this is the default for \code{\link{shiny_iconlink}}. For elements activated
by hovering, embed a \code{shiny::icon("info")}.
}
\examples{
library("shiny")

numericInput(inputId = "foo", label = "Enter a number", value = 0) \%>\%
  shinyInput_label_embed(
    shiny_iconlink() \%>\%
    bs_embed_popover(title = "Number", content = "Not a complex number")
  )

}
\seealso{
\code{\link{shiny_iconlink}}
}
