% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{shadowed_packages}
\alias{shadowed_packages}
\title{Find Shadowed Packages}
\usage{
shadowed_packages(lib.loc = NULL)
}
\arguments{
\item{lib.loc}{character vector describing the location of the \R library
trees to search through, or \code{NULL} for all known trees
(see \code{\link{.libPaths}}).}
}
\value{
A \code{data.frame} with one row per package, row names the package
names and column names (currently) "Package", "LibPath", "Version",
"Shadow.LibPath", "Shadow.Version", "Shadow.Newer".
}
\description{
Find packages that are \emph{shadowed} by others in library locations
with a higher priority.
}
\details{
\R supports setting several locations for library trees. This is a
powerful feature, but many times packages end up installed in multiple
locations, and in such cases \R silently uses the one in the path with the
highest priority (appearing first in \code{\link{.libPaths}}), thus
\emph{shadowing} packages in locations with a lower priority.

For \pkg{bspm} installations, this means that outdated user packages may
break system libraries. This utility reports packages that are shadowed
(one per row) with information on which location ("Shadow.LibPath")
and version ("Shadow.Version") has priority over it.
The \code{\link{moveto_sys}} method is a great complement to move such
outdated versions to the system libraries.
}
\seealso{
\code{\link{moveto_sys}}
}
